<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
// 选项
class ZM_Festival {
	private $zm_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'zm_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'zm_page_init' ) );
	}

	public function zm_add_plugin_page() {
		add_options_page(
			'节日装点',
			'节日装点',
			'manage_options',
			'festival_options',
			array( $this, 'zm_create_admin_page' )
		);
	}

	public function zm_create_admin_page() {
		$this->zm_options = get_option( 'zm_option_name' ); ?>

		<div class="wrap">
			<h2>节日装点</h2>
			<p></p>
			<?php settings_errors(); ?>

			<form method="post" action="options.php">
				<?php
					settings_fields( 'zm_option_group' );
					do_settings_sections( 'zm-admin' );
					submit_button();
				?>
			</form>
		</div>
	<?php }

	public function zm_page_init() {
		register_setting(
			'zm_option_group',
			'zm_option_name',
			array( $this, 'zm_sanitize' )
		);

		add_settings_section(
			'zm_setting_section',
			'设置',
			array( $this, 'zm_section_info' ),
			'zm-admin'
		);

		add_settings_field(
			'dll',
			'左灯笼[www.qymao.cn]',
			array( $this, 'dll_callback' ),
			'zm-admin',
			'zm_setting_section'
		);

		add_settings_field(
			'dlr',
			'右灯笼',
			array( $this, 'dlr_callback' ),
			'zm-admin',
			'zm_setting_section'
		);

		add_settings_field(
			'hb',
			'飘花瓣',
			array( $this, 'hb_callback' ),
			'zm-admin',
			'zm_setting_section'
		);

		add_settings_field(
			'mh',
			'梅花枝',
			array( $this, 'mh_callback' ),
			'zm-admin',
			'zm_setting_section'
		);

		add_settings_field(
			'mo',
			'移动端',
			array( $this, 'mo_callback' ),
			'zm-admin',
			'zm_setting_section'
		);

	}

	public function zm_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['dll'] ) ) {
			$sanitary_values['dll'] = $input['dll'];
		}

		if ( isset( $input['dlr'] ) ) {
			$sanitary_values['dlr'] = $input['dlr'];
		}

		if ( isset( $input['hb'] ) ) {
			$sanitary_values['hb'] = $input['hb'];
		}

		if ( isset( $input['mh'] ) ) {
			$sanitary_values['mh'] = $input['mh'];
		}

		if ( isset( $input['mo'] ) ) {
			$sanitary_values['mo'] = $input['mo'];
		}

		return $sanitary_values;
	}

	public function zm_section_info() {
		
	}

	public function dll_callback() {
		printf(
			'<input type="checkbox" name="zm_option_name[dll]" id="dll" value="dll" %s> <label for="dll">显示</label>',
			( isset( $this->zm_options['dll'] ) && $this->zm_options['dll'] === 'dll' ) ? 'checked' : ''
		);
	}

	public function dlr_callback() {
		printf(
			'<input type="checkbox" name="zm_option_name[dlr]" id="dlr" value="dlr" %s> <label for="dlr">显示</label>',
			( isset( $this->zm_options['dlr'] ) && $this->zm_options['dlr'] === 'dlr' ) ? 'checked' : ''
		);
	}

	public function hb_callback() {
		printf(
			'<input type="checkbox" name="zm_option_name[hb]" id="hb" value="hb" %s> <label for="hb">显示</label>',
			( isset( $this->zm_options['hb'] ) && $this->zm_options['hb'] === 'hb' ) ? 'checked' : ''
		);
	}

	public function mh_callback() {
		printf(
			'<input type="checkbox" name="zm_option_name[mh]" id="mh" value="mh" %s> <label for="mh">显示</label>',
			( isset( $this->zm_options['mh'] ) && $this->zm_options['mh'] === 'mh' ) ? 'checked' : ''
		);
	}

	public function mo_callback() {
		printf(
			'<input type="checkbox" name="zm_option_name[mo]" id="mo" value="mo" %s> <label for="mo">显示</label>',
			( isset( $this->zm_options['mo'] ) && $this->zm_options['mo'] === 'mo' ) ? 'checked' : ''
		);
	}

}
if ( is_admin() ) {
	$zm = new ZM_Festival();
}

if ( ! function_exists( 'fe_get_option' ) ) :
function fe_get_option( $name, $default = false ) {
	$zm_options = get_option( 'zm_option_name' );
	if ( isset( $zm_options[$name] ) ) {
		return $zm_options[$name];
	}
	return $default;
}
endif;